define([
    'underscore',
    'modules/appointments/list-section/appointments-list-item-view',
], function(_, AppointmentsListItemView) {
    'use strict';

    describe('Appointments List Item View', function() {
        var TestItemView = AppointmentsListItemView.extend({
            template: _.template('<button type="button">Click for details</button>'),
            showDetails: _.noop,
        });
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            spyOn(TestItemView.prototype, 'showDetails');
            view = new TestItemView();

            $('body').append('<ol class="test-appointments-list"></ol>');
            $('.test-appointments-list').append(view.render());
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $view.remove();
            $('.test-appointments-list').remove();
        });

        // afterAll(function() {
        //  $('.test-appointments-list').remove();
        // });

        it('has tagName li', function() {
            expect(view.tagName).toEqual('li');
        });

        it('calls showDetails() on click of button', function() {
            $view.find('button').trigger('click');
            expect(view.showDetails).toHaveBeenCalled();
        });
    });
});
